%% DATI NUMERICI %% 


Text = 223.15;            %temperatura esterna di corciera a Mach5 in Kelvin Z25000m

Mach = 5 ;




Thrust_ramjet = 10;       %Ramjet thrust [kN]



M_vehicle_dry_noengine_MR5 = 0;
M_engineATR_dry_MR5 = 4000;           %ATR one engine kg
M_engineDMR_dry_MR5 = 1400;           %DMR one engine kg
M_engine_dry_MR5 = 4000+1400;         %ATR+DMR one engine kg


                   
n_subcontractors=5;                      %number of sub-contractors in the project
n_stage = 1;              %number of stages for the vehicle

f0= 1.04^n_stage;         %Systems engineering / integration factor(Development)           
f1= 0.3;                  %Development standard factor (from 0.3 for a variation of an existing project; to 1.4 for a new concept involving new techniques and technologies)
f2= Mach.^0.15;            %Technical quality factor
f3= 1.4;                  %Team experience factor(from 0.5 for extended experience; to 1.4 for new team with no experience)
f4= 0;                    %Learning curve factor
f6= 1;                    %Deviation from optimal schedule  (1 for on-time and up to 1.6 for heavy delays)
f7= n_subcontractors^0.2;                %Program organization factor
f8= 0.86;                 %Impact of region productivity (1 for USA, 0.86 for Europe, 1.2 for China, 1.5 to 2.1 for Russia)
f9= 0;                    %Impact of subcontractors
f10= 0;
f11= 0;                   %Reduction factor due to absence of government contracts
f0_new= 0;
f10_new= 0;               %Cost reduction factor
f11_new= 0;             

vel_sound= (1.4*287*Text)^0.5;                       %m/s

velocity_cruise= vel_sound.*Mach;                     %m/s
velocity_cruise_KMH = velocity_cruise*3.6;           %km/h



M_vehicle_dry_noengine = 200000;                         % dry mass of vehicle without engines kg
       

Moew = 130000;                      %kg


M_engineATR_dry = 4000;           %ATR one engine kg
M_engineDMR_dry = 1400;           %DMR one engine kg
M_engine_dry = 4000+1400;         %1ATR+1DMR one engine kg

C_complex= 3;
Ktj= 0.5;                             %low-speed configuration coefficients ranging from 0 to 1
Krj= 0.5;                             %high-speed configuration coefficients ranging from 0 to 1

K_TRL = 0.5 ;                          %factor accounting for the vehicle maturity (from 0 for an average TRL 1 to 1 for an average TRL of 9)

CPI_2023 = 240.01;                          %Consumer Price Index 2023?
CPI_2016 = 240.01;                          %Consumer Price Index reference (2016)

MYr_to_Milion_factor = 0.3102;

%% RDTE RESEARCH V2 %MYr %System Level - Vehicle

%Transcost

%RDTE cost for high speed advanced aircraft [WYr]
%Hva_originalTRANSCOST = (2880*(M_vehicle_dry_noengine^0.241))*f1*f2*f3;
%Hva_research=(1746*(M_vehicle_dry_noengine.^0.284)*f1*f3).*(Mach.^0.15);

M_vehicle_dry_noengine_variable = 4000:4000:200000; 
Mach_variable = 0.4:0.4:20;


Mach_1 = [1, 2, 3, 5, 8, 10, 20];
figure(1)
for k=1:length(Mach_1)
    Hva_mass_variable=(1746*(M_vehicle_dry_noengine_variable.^0.284)*f1*f3).*(Mach_1(k).^0.15);
    txt = ['Mach = ',num2str(Mach_1(k))];
    plot(M_vehicle_dry_noengine_variable,Hva_mass_variable,'DisplayName',txt)
    hold on
end
xlabel({'Vehicle dry no-engine Mass','[kg]'})
ylabel({'H_V_A RDTE Vehicle w/o engines cost ','[MYr]'})
legend show
grid on
f = figure(1);  
f.Position = [100 100 800 600]; 

M_vehicle_dry_noengine_1 = [25000, 50000, 75000, 100000, 125000, 150000, 200000];
figure(2)
for k=1:length(M_vehicle_dry_noengine_1)
   Hva_mach_variable=(1746*(M_vehicle_dry_noengine_1(k).^0.284)*f1*f3).*(Mach_variable.^0.15);
   txt = ['Vehicle dry no-engine Mass = ',num2str(M_vehicle_dry_noengine_1(k)),'kg'];
   plot(Mach_variable,Hva_mach_variable,'DisplayName',txt)
   hold on
end
xlabel({'Mach'})
ylabel({'H_V_A RDTE Vehicle w/o engines cost ','[MYr]'})
legend show
grid on
f = figure(2);  
f.Position = [100 100 800 600]; 

i=0:1:length(M_vehicle_dry_noengine_variable);
j=0:1:length(Mach_variable);
for i=1:length(M_vehicle_dry_noengine_variable)
    for j=1:length(Mach_variable)
        Hva_matrix(i,j) =(1746*(M_vehicle_dry_noengine_variable(i).^0.284)*f1*f3).*(Mach_variable(j).^0.15);     %airframe (with subsystems), or vehicle without engines
    end 
end

Database_x = [2, 3, 5, 6, 20];
Database_y = [66000, 79200, 170000, 6605, 133250];

for i=1:length(Database_y)
    
        Hva_matrix_database(i) =(1746*(Database_y(i).^0.284)*f1*f3).*(Database_x(i).^0.15);     %airframe (with subsystems), or vehicle without engines
        
   
end

figure(3)
surf(Mach_variable,M_vehicle_dry_noengine_variable,Hva_matrix)
xlabel({'Mach'})
ylabel({'Vehicle dry no-engine Mass','[kg]'})
zlabel({'H_V_A RDTE Vehicle w/o engines cost ','[MYr]'})
hold on
Database_name =["Concorde", "XB-70", "LAPCAT A2", "X-15", "SpaceLiner Orbiter"];
for kont=1:length(Database_x)
    plot3(Database_x(kont),Database_y(kont),Hva_matrix_database(kont),'.','MarkerSize',30,'DisplayName',Database_name(kont))
    hold on
end
    
legend show
colormap parula
colorbar
grid on
f = figure(3);  
f.Position = [100 100 900 675]; 


%% RDTE RESEARCH V2 %MYr %System Level - Propulsion system

%Transcost

%RDTE cost for turbojet engine [WYr]
%Het_originalTRANSCOST = (1380*(M_engineATR_dry^0.295))*f1*f3;
%Het_research=(1380*(M_engineATR_dry^0.295)+1.12*velocity_cruise_engine)*f1*f3;

velocity_cruise_engine = 200;   %maximum operative speed of the engine [m/s]

M_engineATR_dry_variable = 200:200:12000;
velocity_cruise_engine_variable = 40:40:2000;

velocity_cruise_engine_1 = [100, 200, 300, 500, 800, 1000, 1250, 1500, 2000];
figure(4)
for k=1:length(velocity_cruise_engine_1)
    Het_massengine_variable=(1380*(M_engineATR_dry_variable.^0.295)+1.12.*velocity_cruise_engine_1(k))*f1*f3;
    txt = ['v = ',num2str(velocity_cruise_engine_1(k)),' [m/s]'];
    plot(M_engineATR_dry_variable,Het_massengine_variable,'DisplayName',txt)
    hold on
end
xlabel({'ATR engine dry Mass','[kg]'})
ylabel({'H_E_T RDTE ATR Engine Cost','[MYr]'})
legend show
grid on
f = figure(4);  
f.Position = [100 100 800 600]; 


M_engineATR_dry_1 = [1000, 2000, 3000, 5000, 7500, 10000];

figure(5)
for k=1:length(M_engineATR_dry_1)
    Het_velocity_cruise_engine_variable=(1380*(M_engineATR_dry_1(k).^0.295)+1.12.*velocity_cruise_engine_variable)*f1*f3;
    txt = ['ATR engine dry Mass = ',num2str(M_engineATR_dry_1(k)),' [kg]'];
    plot(velocity_cruise_engine_variable,Het_velocity_cruise_engine_variable,'DisplayName',txt)
    hold on
end
xlabel({'Maximum engine speed','[m/s]'})
ylabel({'H_E_T RDTE ATR Engine Cost','[MYr]'})
legend show
grid on
f = figure(5);  
f.Position = [100 100 800 600];

i=0:1:length(velocity_cruise_engine_variable);
j=0:1:length(M_engineATR_dry_variable);
for i=1:length(velocity_cruise_engine_variable)
    for j=1:length(M_engineATR_dry_variable)
        Het_matrix(i,j) =(1380*(M_engineATR_dry_variable(j)^0.295)+1.12*velocity_cruise_engine_variable(i))*f1*f3;
    end 
end

Database_xe = [600, 889, 1667];
Database_ye = [3175, 2300, 10200];

for ii=1:length(Database_xe)
        Het_matrix_database(ii) =(1380*(Database_ye(ii)^0.295)+1.12*Database_xe(ii))*f1*f3;
end

figure(6)
surf(M_engineATR_dry_variable,velocity_cruise_engine_variable,Het_matrix)
ylabel({'Maximum engine speed','[m/s]'})
xlabel({'ATR engine dry Mass','[kg]'})
zlabel({'H_E_T RDTE ATR Engine Cost','[MYr]'})
hold on

Database_name2 =["Concorde", "XB-70", "LAPCAT A2"];
for kont=1:length(Database_xe)
    plot3(Database_ye(kont),Database_xe(kont),Het_matrix_database(kont),'.','MarkerSize',30,'DisplayName',Database_name2(kont))
    hold on
end

legend show
colormap turbo
colorbar
grid on
f = figure(6);  
f.Position = [100 100 900 675];

                                                %RDTE cost for ramjet engine [WYr]

%Her_research=355*(M_engineDMR_dry^0.295)*f1*f3;

M_engineDMR_dry_variable = 200:200:12000;
Her_massengine_variable=355*(M_engineDMR_dry_variable.^0.295)*f1*f3;

figure(7)
plot(M_engineDMR_dry_variable,Her_massengine_variable)
xlabel({'DMR engine dry Mass','[kg]'})
ylabel({'H_E_R RDTE DMR Engine Cost','[MYr]'})
grid on
f = figure(7);  
f.Position = [100 100 800 600];

%RDTE cost for Combined Cycle Engine [WYr]
M_engine_dry_variable = 200:200:12000;

for cont2=1:length(M_engine_dry_variable)
    Hcce_RDTE(cont2)=C_complex.*(Ktj.*((1380*(M_engine_dry_variable(cont2).^0.295)+1.12.*velocity_cruise_engine_1(7))*f1*f3)+Krj.*(355*(M_engine_dry_variable(cont2).^0.295)*f1*f3)).*(f1*f3);
end

figure(8)
plot(M_engine_dry_variable,Hcce_RDTE)
xlabel({'Engine dry Mass','[kg]'})
ylabel({'H_C_C_E Combined cycle engine RDTE Cost','[MYr]'})
hold on
grid on
f = figure(8);  
f.Position = [100 100 800 600];
%Hcce_RDTE=C_complex.*(Ktj.*Het_research+Krj.*Her_research).*(f1*f3);


%Total RDTE cost [WYr]_[M$]

%Cost_TOT_RDTE = ((1-K_TRL)*(f0^n_stage)*(Hva_research + Her_research + Hcce_research)*f6*f7*f8)*MYr_to_Milion_factor*(CPI_2023/CPI_2016);


%% RDTE RESEARCH V2 %MYr % Subsystem Level __FUEL SYSTEM

%Transcost

mpunto_bo_LH2 = 1;              %Boil-off flow rate [kg/s]
P = 10000;                      %Power produced by TEMS [W]
q = 10000;                      %Heat flux [W/m^2]
n_engine_types = 2;             %Number of engine types installed
rho_LH2 = 70.9;                %fuel density [kg/m3]

Moew_variable = 0:5000:200000;
M_engine_dry_variable = 0:1250:50000;

%RDTE cost for fuel system [WYr]

%S_fuel_RDTE = ((0.1.*(Moew.^0.68))+(0.5.*(rho_LH2.^(-0.6)))+(0.49.*(M_engine_dry.^0.51)))*f1*f3;

M_engine_dry_1 = [1000, 2500, 5000, 10000, 20000, 30000, 40000, 50000];
figure(9)
for k=1:length(M_engine_dry_1)
    S_fuel_RDTE_Moew_variable = ((0.1.*(Moew_variable.^0.68))+(0.5.*(rho_LH2.^(-0.6)))+(0.49.*(M_engine_dry_1(k).^0.51)))*f1*f3;
    txt = ['Engine dry Mass = ',num2str(M_engine_dry_1(k)),' [kg]'];
    plot(Moew_variable,S_fuel_RDTE_Moew_variable,'DisplayName',txt)
    hold on
end
xlabel({'Operating empty weight M_O_E_W','[kg]'})
ylabel({'Fuel system RDTE Cost','[MYr]'})
legend show
grid on
f = figure(9);  
f.Position = [100 100 800 600];

Moew_1 = [50000, 100000, 120000, 150000, 180000, 200000];
figure(10)
for k=1:length(Moew_1)
    S_fuel_RDTE_M_engine_dry_variable = ((0.1.*(Moew_1(k).^0.68))+(0.5.*(rho_LH2.^(-0.6)))+(0.49.*(M_engine_dry_variable.^0.51)))*f1*f3;
    txt = ['M_O_E_W = ',num2str(Moew_1(k)),' [kg]'];
    plot(M_engine_dry_variable,S_fuel_RDTE_M_engine_dry_variable,'DisplayName',txt)
    hold on
end
xlabel({'Engine dry Mass','[kg]'})
ylabel({'Fuel system RDTE Cost','[MYr]'})
legend show
grid on
f = figure(10);  
f.Position = [100 100 800 600];

i=0:1:length(M_engine_dry_variable);
j=0:1:length(Moew_variable);
for i=1:length(M_engine_dry_variable)
    for j=1:length(Moew_variable)
        S_fuel_RDTE_matrix(i,j) =((0.1.*(Moew_variable(j).^0.68))+(0.5.*(rho_LH2.^(-0.6)))+(0.49.*(M_engine_dry_variable(i).^0.51)))*f1*f3;
    end 
end

i = 0;
j = 0;
k = 0;

figure(11)
surf(Moew_variable,M_engine_dry_variable,S_fuel_RDTE_matrix)
xlabel({'Operating empty weight M_O_E_W','[kg]'})
ylabel({'Engine dry Mass','[kg]'})
zlabel({'Fuel system RDTE Cost','[MYr]'})

colormap turbo
colorbar
grid on
f = figure(11);  
f.Position = [100 100 900 675];

%% RDTE RESEARCH V2 %MYr % Subsystem Level __TPS SYSTEM

%Transcost

mpunto_bo_LH2 = 1;              %Boil-off flow rate [kg/s]
P = 10000;                      %Power produced by TEMS [W]
q = 10000;                      %Heat flux [W/m^2]
n_engine_types = 2;             %Number of engine types installed
rho_LH2 = 70.74;                 %fuel density [kg/m3]

Moew_variable = 0:5000:200000;
q_variable = 0:140000:7000000;

%RDTE cost for TPS system [WYr]

%S_TPS_RDTE = ((0.56*(Moew^0.59))+(1.8*(q^0.51)))*f1*f3;


q_1 = [40000, 140000, 300000, 500000, 1000000, 2000000, 3500000, 7000000];
figure(12)
for k=1:length(q_1)
    S_TPS_RDTE_Moew_variable = ((0.56.*(Moew_variable.^0.59))+(1.8.*(q_1(k).^0.51)))*f1*f3;
    txt = ['Heat flux = ',num2str(q_1(k)),' [W/m^2]'];
    plot(Moew_variable,S_TPS_RDTE_Moew_variable,'DisplayName',txt)
    hold on
end
xlabel({'Operating empty weight M_O_E_W','[kg]'})
ylabel({'TPS system RDTE Cost','[MYr]'})
legend show
grid on
f = figure(12);  
f.Position = [100 100 800 600];

Moew_1 = [50000, 100000, 120000, 150000, 180000, 200000];
figure(13)
for k=1:length(Moew_1)
    S_TPS_RDTE_q_variable = ((0.56.*(Moew_1(k).^0.59))+(1.8.*(q_variable.^0.51)))*f1*f3;
    txt = ['M_O_E_W = ',num2str(Moew_1(k)),' [kg]'];
    plot(q_variable,S_TPS_RDTE_q_variable,'DisplayName',txt)
    hold on
end
xlabel({'Heat flux','[W/m^2]'})
ylabel({'TPS system RDTE Cost','[MYr]'})
legend show
grid on
f = figure(13);  
f.Position = [100 100 800 600];

i=0:1:length(q_variable);
j=0:1:length(Moew_variable);
for i=1:length(q_variable)
    for j=1:length(Moew_variable)
        S_TPS_RDTE_matrix(i,j) = ((0.56.*(Moew_variable(j).^0.59))+(1.8.*(q_variable(i).^0.51)))*f1*f3;
    end 
end

i = 0;
j = 0;
k = 0;

figure(14)
surf(Moew_variable,q_variable,S_TPS_RDTE_matrix)
xlabel({'Operating empty weight M_O_E_W','[kg]'})
ylabel({'Heat flux','[W/m^2]'})
zlabel({'TPS system RDTE Cost','[MYr]'})
colormap turbo
colorbar
grid on
f = figure(14);  
f.Position = [100 100 900 675];


%% RDTE RESEARCH V2 %MYr % Subsystem Level __TEMS SYSTEM

%Transcost

mpunto_bo_LH2 = 1;              %Boil-off flow rate [kg/s]
P = 10000;                      %Power produced by TEMS [W]
q = 10000;                      %Heat flux [W/m^2]
n_engine_types = 2;             %Number of engine types installed
rho_LH2 = 70.9;                 %fuel density [kg/m3]

Moew_variable = 5000:5000:200000;
P_variable = 20000:20000:1000000;

%RDTE cost for TEMS [WYr]

%S_TEMS_RDTE= ((5.73*(Moew^0.26))+(0.8*(P^0.17))+(0.53*(mpunto_bo_LH2^0.19)))*f1*f3;


P_1 = [10000, 50000, 100000, 250000, 500000, 1000000];
figure(15)
for k=1:length(P_1)
    S_TEMS_RDTE_P_variable = ((5.73.*(Moew_variable.^0.26))+(0.8.*(P_1(k).^0.17))+(0.53*(mpunto_bo_LH2^0.19)))*f1*f3;
    txt = ['Power produced by TEMS = ',num2str(P_1(k)),' [W]'];
    plot(Moew_variable,S_TEMS_RDTE_P_variable,'DisplayName',txt)
    hold on
end
xlabel({'Operating empty weight M_O_E_W','[kg]'})
ylabel({'TEMS system RDTE Cost','[MYr]'})
legend show
grid on
f = figure(15);  
f.Position = [100 100 800 600];


Moew_1 = [50000, 100000, 120000, 150000, 180000, 200000];
figure(16)
for k=1:length(Moew_1)
    S_TEMS_RDTE_P_variable = ((5.73.*(Moew_1(k).^0.26))+(0.8.*(P_variable.^0.17))+(0.53*(mpunto_bo_LH2^0.19)))*f1*f3;
    txt = ['M_O_E_W = ',num2str(Moew_1(k)),' [kg]'];
    plot(P_variable,S_TEMS_RDTE_P_variable,'DisplayName',txt)
    hold on
end
xlabel({'Power produced by TEMS','[W]'})
ylabel({'TEMS system RDTE Cost','[MYr]'})
legend show
grid on
f = figure(16);  
f.Position = [100 100 800 600];

i=0:1:length(P_variable);
j=0:1:length(Moew_variable);
for i=1:length(P_variable)
    for j=1:length(Moew_variable)
        S_TEMS_RDTE_matrix(i,j) = ((5.73.*(Moew_variable(j).^0.26))+(0.8.*(P_variable(i).^0.17))+(0.53*(mpunto_bo_LH2^0.19)))*f1*f3;
    end 
end

i = 0;
j = 0;
k = 0;

figure(17)
surf(Moew_variable,P_variable,S_TEMS_RDTE_matrix)
xlabel({'Operating empty weight M_O_E_W','[kg]'})
ylabel({'Power produced by TEMS','[W]'})
zlabel({'TEMS system RDTE Cost','[MYr]'})

colormap turbo
colorbar
grid on
f = figure(17);  
f.Position = [100 100 900 675];


%% RDTE RESEARCH V2 %MYr % Subsystem Level __OTHER SUBSYSTEM

%{ 
COSTO RDTE TOT - (COSTO PROPULSION SYSTEM + COSTO FUEL SYSTEM + COSTO TPS SYSTEM + COSTO TEMS SYSTEM )

OPPURE COSTO RDTE VEHICLE W/O ENGINE - (COSTO FUEL SYSTEM + COSTO TPS SYSTEM + COSTO TEMS SYSTEM)

A QUESTA RIMANENZA SCALARE LE PERCENTUALI




%}

